/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.model;

import itx.erp.ErpObjectContainer;
import itx.erp.base.util.LangUtil;
import itx.erp.sales.model.ArticleSlotplanPrice;
import itx.erp.sales.model.Vat;
import itx.erp.sales.rental.model.RentalContractLine;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jtbcore.model.BaseStringMap;
import jtbcore.model.BaseStringMapObject;
import jtbcore.util.DateUtil;
import jtbcore.util.NumberUtil;

public class Article
implements BaseStringMapObject {
    protected BaseStringMap bsm = new BaseStringMap();
    protected Vat vat = null;
    protected List<Integer> articleGroupIds = new ArrayList<Integer>();
    protected Integer mainArticleGroupId = null;
    protected List<ArticleSlotplanPrice> slotplanPrices = new ArrayList<ArticleSlotplanPrice>();
    protected List<RentalContractLine> contractLines;

    public Vat getVat() {
        return this.vat;
    }

    public void setVat(Vat vat) {
        this.vat = vat;
    }

    public Integer getArticleId() {
        return this.bsm.getPropertyInt("article_id");
    }

    public void setArticleId(Integer p) {
        this.bsm.setProperty("article_id", p);
    }

    public String getArticleCode() {
        return this.bsm.getProperty("article_code");
    }

    public void setArticleCode(String c) {
        this.bsm.setProperty("article_code", c);
    }

    public String getShortDescription() {
        return this.bsm.getProperty("short_description");
    }

    public void setShortDescription(String c) {
        this.bsm.setProperty("short_description", c);
    }

    public String getLongDescription() {
        return this.bsm.getProperty("long_description");
    }

    public void setLongDescription(String c) {
        this.bsm.setProperty("long_description", c);
    }

    public String getNote() {
        return this.bsm.getProperty("note");
    }

    public void setNote(String c) {
        this.bsm.setProperty("note", c);
    }

    public Boolean isRentable() {
        return this.bsm.getPropertyBool("rentable");
    }

    public Boolean getRentable() {
        return this.bsm.getPropertyBool("rentable");
    }

    public void setRentable(Boolean c) {
        this.bsm.setProperty("rentable", c);
    }

    public Boolean isOverbookable() {
        return this.bsm.getPropertyBool("overbookable");
    }

    public Boolean getOverbookable() {
        return this.bsm.getPropertyBool("overbookable");
    }

    public void setOverbookable(Boolean c) {
        this.bsm.setProperty("overbookable", c);
    }

    public Integer getMaxBookable() {
        return this.bsm.getPropertyInt("max_bookable");
    }

    public void setMaxBookable(Integer c) {
        this.bsm.setProperty("max_bookable", c);
    }

    public Double getPriceExclVat() {
        return this.bsm.getPropertyDouble("price_excl_vat");
    }

    public void setPriceExclVat(Double p) {
        this.bsm.setProperty("price_excl_vat", p);
    }

    public Double getPriceInclVat() {
        return this.bsm.getPropertyDouble("price_incl_vat");
    }

    public void setPriceInclVat(Double p) {
        this.bsm.setProperty("price_incl_vat", p);
    }

    public Integer getVatId() {
        return this.bsm.getPropertyInt("vat_id");
    }

    public void setVatId(Integer c) {
        this.bsm.setProperty("vat_id", c);
    }

    public String getPricingMethod() {
        return this.bsm.getProperty("pricing_method");
    }

    public void setPricingMethod(String c) {
        this.bsm.setProperty("pricing_method", c);
    }

    public Integer getSlotplanId() {
        return this.bsm.getPropertyInt("slotplan_id");
    }

    public void setSlotplanId(Integer c) {
        this.bsm.setProperty("slotplan_id", c);
    }

    public Integer getDaypriceId() {
        return this.bsm.getPropertyInt("dayprice_id");
    }

    public void setDaypriceId(Integer c) {
        this.bsm.setProperty("dayprice_id", c);
    }

    public Boolean isActive() {
        return this.bsm.getPropertyBool("active");
    }

    public Boolean getActive() {
        return this.bsm.getPropertyBool("active");
    }

    public void setActive(Boolean c) {
        this.bsm.setProperty("active", c);
    }

    public Date getEdited() {
        return this.bsm.getPropertyDateTime("edited");
    }

    public void setEdited(Date d) {
        this.bsm.setProperty("edited", DateUtil.datetime2string(d));
    }

    public Date getCreated() {
        return this.bsm.getPropertyDateTime("created");
    }

    public void setCreated(Date d) {
        this.bsm.setProperty("created", DateUtil.datetime2string(d));
    }

    public String getDisplayPrice() {
        String p = ErpObjectContainer.getInstance().getSalesSettings().inputPriceExclVat() ? NumberUtil.formatPrice(this.getPriceExclVat()) + " excl. btw" : NumberUtil.formatPrice(this.getPriceInclVat()) + " incl. btw";
        return p;
    }

    public String getPriceDescription() {
        Object p = ErpObjectContainer.getInstance().getSalesSettings().inputPriceExclVat() ? NumberUtil.formatPrice(this.getPriceExclVat()) : NumberUtil.formatPrice(this.getPriceInclVat());
        if (this.isRentable().booleanValue()) {
            String t = LangUtil.getInstance().t("pricingmethod." + this.getPricingMethod());
            p = (String)p + " / " + t;
        }
        return p;
    }

    public List<Integer> getArticleGroupIds() {
        return this.articleGroupIds;
    }

    public void setArticleGroupIds(List<Integer> articleGroupIds) {
        this.articleGroupIds = articleGroupIds;
    }

    public Integer getMainArticleGroupId() {
        return this.mainArticleGroupId;
    }

    public void setMainArticleGroupId(Integer mainArticleGroupId) {
        this.mainArticleGroupId = mainArticleGroupId;
    }

    public List<ArticleSlotplanPrice> getSlotplanPrices() {
        return this.slotplanPrices;
    }

    public void setSlotplanPrices(List<ArticleSlotplanPrice> slotplanPrices) {
        this.slotplanPrices = slotplanPrices;
    }

    public List<RentalContractLine> getRentalContractLines() {
        return this.contractLines;
    }

    public void setRentalContractLines(List<RentalContractLine> contractLines) {
        this.contractLines = contractLines;
    }

    @Override
    public BaseStringMap getBaseStringMap() {
        return this.bsm;
    }

    @Override
    public void setBaseStringMap(BaseStringMap bsm) {
        this.bsm = bsm;
    }
}

